# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-09-03 09:53
from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import intranet.femida.src.core.db.fields
import intranet.femida.src.utils.datetime
import functools
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('candidates', '0012_candidatesubmission_is_fast_rejection'),
    ]

    operations = [
        migrations.CreateModel(
            name='Verification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
                ('expiration_date', models.DateTimeField(blank=True, null=True)),
                ('resolution', models.CharField(blank=True, choices=[('hire', 'verification.resolution.hire'), ('nohire', 'verification.resolution.nohire'), ('blacklist', 'verification.resolution.blacklist')], max_length=32)),
                ('link_expiration_date', models.DateTimeField(default=functools.partial(intranet.femida.src.utils.datetime.shifted_now, *(), **{'days': 30}))),
                ('startrek_ess_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(blank=True, max_length=32)),
                ('raw_data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict)),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='verifications', to='interviews.Application')),
                ('candidate', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='verifications', to='candidates.Candidate')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='created_verifications', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
