from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('candidates', '0021_add_role_to_unique_together'),
    ]

    operations = [
        migrations.RunSQL(
            sql=("""
                UPDATE candidates_candidate_responsibles SET role = 'main_recruiter'
                WHERE
                  id IN (
                    SELECT MIN(id) FROM candidates_candidate_responsibles
                    GROUP BY candidate_id
                  )
                  AND candidate_id NOT IN (
                    SELECT candidate_id FROM candidates_candidate_responsibles
                    WHERE role = 'main_recruiter'
                  );
            """),
            reverse_sql="UPDATE candidates_candidate_responsibles SET role = 'recruiter'",
        ),
    ]
