# Generated by Django 2.2.23 on 2021-05-13 16:51

import re
from collections import defaultdict
from itertools import chain

from django.db import migrations
from django.db.models import F, Value, CharField

from intranet.femida.src.candidates.choices import CONTACT_TYPES
from intranet.femida.src.candidates.contacts import normalize_contact_url
from intranet.femida.src.utils.queryset import queryset_iterator


AH_URL_PATTERN = fr'.*search\.amazinghiring\.(com|ru)/profiles/\d+/?$'
AH_RGX = re.compile(AH_URL_PATTERN, re.IGNORECASE)


def is_ah_profile_url(contact):
    return AH_RGX.match(contact) is not None


def create_new_ah_contacts_from_source_description(apps, data):
    CandidateContact = apps.get_model('candidates', 'CandidateContact')
    ah_contacts_by_candidate_id = defaultdict(set)

    ah_contacts = []
    ah_contacts_update = []
    for row in data:
        candidate_id = row.candidate_id
        normalized = normalize_contact_url(CONTACT_TYPES.ah, row.source_description)
        if not normalized or normalized in ah_contacts_by_candidate_id[candidate_id]:
            continue

        ah_contacts_by_candidate_id[candidate_id].add(normalized)

        if row.q_type == 'contact' and is_ah_profile_url(row.source_description):
            row.type = CONTACT_TYPES.ah
            row.normalized_account_id = normalized
            ah_contacts_update.append(row)
            continue

        ah_contacts.append(
            CandidateContact(
                account_id=normalized,
                normalized_account_id=normalized,
                candidate_id=candidate_id,
                type=CONTACT_TYPES.ah,
                is_active=True,
            )
        )

    CandidateContact.objects.bulk_create(ah_contacts, batch_size=1000)
    CandidateContact.objects.bulk_update(
        ah_contacts_update,
        ['type', 'normalized_account_id'],
        batch_size=1000,
    )


def create_ah_contacts(apps, schema_editor):
    Candidate = apps.get_model('candidates', 'Candidate')
    Consideration = apps.get_model('candidates', 'Consideration')
    CandidateContact = apps.get_model('candidates', 'CandidateContact')

    candidates_data = queryset_iterator(
        queryset=(
            Candidate.unsafe
            .filter(source_description__icontains='amazinghiring')
            .annotate(candidate_id=F('id'), q_type=Value('candidate', CharField()))
            .values_list('pk', 'q_type', 'candidate_id', 'source_description', named=True)
        ),
        chunk_size=10000,
    )
    considerations_data = queryset_iterator(
        queryset=(
            Consideration.unsafe
            .filter(source_description__icontains='amazinghiring')
            .annotate(q_type=Value('consideration', CharField()))
            .values_list('pk', 'q_type', 'candidate_id', 'source_description', named=True)
        ),
        chunk_size=10000,
    )
    contacts_data = queryset_iterator(
        queryset=(
            CandidateContact.objects
            .filter(account_id__icontains='amazinghiring', is_active=True)
            .annotate(source_description=F('account_id'), q_type=Value('contact', CharField()))
        ),
        chunk_size=10000,
    )

    data = chain(candidates_data, considerations_data, contacts_data)
    create_new_ah_contacts_from_source_description(apps, data)


class Migration(migrations.Migration):

    dependencies = [
        ('candidates', '0024_candidatesubmission_publication'),
    ]

    operations = [
        migrations.RunPython(
            code=create_ah_contacts,
            reverse_code=lambda *x, **y: None,
        ),
    ]
