# Generated by Django 2.2.24 on 2021-06-15 08:46

from django.db import migrations
from django.db.models import Prefetch

from intranet.femida.src.candidates.choices import CONTACT_TYPES
from intranet.femida.src.utils.queryset import queryset_iterator

def deactivate_duplicates(apps, schema_editor):
    Candidate = apps.get_model('candidates', 'Candidate')
    CandidateContact = apps.get_model('candidates', 'CandidateContact')
    candidates = queryset_iterator(
        queryset=(
            Candidate.unsafe
            .filter(contacts__type=CONTACT_TYPES.linkedin)
            .prefetch_related(Prefetch(
                'contacts',
                queryset=CandidateContact.objects.filter(type='linkedin', is_active=True),
                to_attr='linkedin_contacts',
            ))
        ),
        chunk_size=10000,
    )
    contacts_to_update = []
    for candidate in candidates:
        normalized_account_ids = set()
        for contact in candidate.linkedin_contacts:
            if contact.normalized_account_id in normalized_account_ids:
                contact.is_active = False
                contacts_to_update.append(contact)
            else:
                normalized_account_ids.add(contact.normalized_account_id)

    CandidateContact.objects.bulk_update(
        contacts_to_update,
        ['is_active'],
        batch_size=1000,
    )


class Migration(migrations.Migration):

    dependencies = [
        ('candidates', '0026_candidate_ah_modified_at'),
    ]

    operations = [
        migrations.RunSQL(
            sql="""
            UPDATE candidates_candidatecontact
            SET normalized_account_id = COALESCE(
                  'https://www.linkedin.com/in/' || substring(
                    account_id,
                    '.*linkedin.com/in/([a-zA-Zа-яА-Я0-9-]+)/?'
                  ),
                  normalized_account_id
                )
            WHERE
              type = 'linkedin'
              AND is_active = 't'
            """,
            reverse_sql=None,
        ),
        migrations.RunPython(
            code=deactivate_duplicates,
            reverse_code=lambda *x, **y: None,
        ),
    ]
