# Generated by Django 2.2.24 on 2021-10-25 10:53

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('candidates', '0033_fill_consideration_is_last'),
    ]

    operations = [
        migrations.CreateModel(
            name='ConsiderationIssue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(max_length=100)),
                ('is_resolved', models.BooleanField(default=False)),
                ('resolved_at', models.DateTimeField(blank=True, null=True)),
                ('level', models.CharField(choices=[('danger', 'consideration_issue.level.danger'), ('warning', 'consideration_issue.level.warning')], max_length=10)),
                ('params', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('consideration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='consideration_issues', to='candidates.Consideration')),
                ('resolved_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='resolved_consideration_issues', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
