# Generated by Django 2.2.24 on 2021-11-10 16:32
import ast

from django.db import migrations
from django.db.models import F
from django.utils import timezone

from intranet.femida.src.utils.queryset import queryset_iterator


def fill_touched_at(apps, schema_editor):
    Candidate = apps.get_model('candidates', 'Candidate')
    TaskResult = apps.get_model('django_celery_results', 'TaskResult')
    Candidate.unsafe.update(touched_at=F('modified'))

    # Достаем всех кандидатов, которые отправлялись в Поиск за последнее время,
    # и считаем, что они обновились сейчас
    task_results = TaskResult.objects.filter(
        task_name='intranet.femida.src.isearch.tasks.bulk_push_candidates_to_isearch',
    )
    candidate_ids = set()
    for task_result in queryset_iterator(task_results):
        args = ast.literal_eval(task_result.task_args)
        kwargs = ast.literal_eval(task_result.task_kwargs)
        if kwargs.get('candidate_ids'):
            candidate_ids.update(kwargs['candidate_ids'])
        else:
            candidate_ids.update(args[0])

    candidates = Candidate.unsafe.filter(id__in=candidate_ids)
    candidates.update(touched_at=timezone.now())


class Migration(migrations.Migration):

    dependencies = [
        ('candidates', '0036_candidate_touched_at'),
    ]

    operations = [
        migrations.RunPython(
            code=fill_touched_at,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
