# Generated by Django 2.2.27 on 2022-03-28 08:09

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0009_languagetag'),
        ('candidates', '0045_candidate_inn'),
    ]

    operations = [
        migrations.CreateModel(
            name='CandidateLanguageTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_main', models.BooleanField(default=False)),
                ('candidate', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='candidate_language_tags', to='candidates.Candidate')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='candidate_language_tags', to='core.LanguageTag')),
            ],
        ),
        migrations.AddConstraint(
            model_name='candidatelanguagetag',
            constraint=models.UniqueConstraint(condition=models.Q(is_main=True), fields=('candidate', 'is_main'), name='candidate_has_only_one_main_language'),
        ),
        migrations.AlterUniqueTogether(
            name='candidatelanguagetag',
            unique_together={('tag', 'candidate')},
        ),
    ]
