# Generated by Django 2.2.28 on 2022-06-23 00:51

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core', '0009_languagetag'),
        ('candidates', '0046_candidate_language_tag'),
    ]

    operations = [
        migrations.CreateModel(
            name='CandidateCostsSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('candidate', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='candidate_costs_set', to='candidates.Candidate')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CandidateCost',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cost_group', models.CharField(choices=[('expectation', 'canidate.cost.group.expectation'), ('current', 'canidate.cost.group.current')], default='expectation', max_length=32)),
                ('type', models.CharField(choices=[('total', 'canidate.cost.type.total'), ('salary', 'canidate.cost.type.salary'), ('salary_bonus', 'canidate.cost.type.salary_bonus'), ('rsu', 'canidate.cost.type.rsu'), ('comment', 'canidate.cost.type.comment')], default='total', max_length=32)),
                ('value', models.PositiveIntegerField(default=None, null=True)),
                ('rate', models.CharField(choices=[('onetime', 'canidate.cost.rate.onetime'), ('hourly', 'canidate.cost.rate.hourly'), ('weekly', 'canidate.cost.rate.weekly'), ('monthly', 'canidate.cost.rate.monthly'), ('quarterly', 'canidate.cost.rate.quarterly'), ('annual', 'canidate.cost.rate.annual')], default=None, max_length=32, null=True)),
                ('taxed', models.BooleanField(default=None, null=True)),
                ('comment', models.CharField(default=None, max_length=255, null=True)),
                ('candidate_costs_set', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='costs', to='candidates.CandidateCostsSet')),
                ('currency', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='core.Currency')),
            ],
        ),
        migrations.AddConstraint(
            model_name='candidatecost',
            constraint=models.UniqueConstraint(fields=('candidate_costs_set', 'cost_group', 'type'), name='idxccth'),
        ),
    ]
