# Generated by Django 2.2.28 on 2022-07-19 16:14

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import intranet.femida.src.core.db.fields
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('interviews', '0013_interview_additional_fields'),
        ('candidates', '0048_verification_type'),
    ]

    operations = [
        migrations.CreateModel(
            name='CandidateCompoundSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='CandidateSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32)),
                ('time_to_live', intranet.femida.src.core.db.fields.RelativeDeltaField(blank=True, default=None, help_text='Postgresql interval field. Using the traditional Postgres format, e.g: "1 years 5 mons 20 days", "3 mons", etc', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='CandidateTouch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('expiration_date', models.DateField(blank=True, default=None, null=True)),
                ('description', models.CharField(blank=True, default=None, max_length=1024, null=True)),
                ('medium', models.CharField(choices=[('vacancy_site', 'candidate.touch.vacancy_site'), ('landing', 'candidate.touch.landing')], max_length=32)),
                ('application', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='candidate_touches', to='interviews.Application')),
                ('candidate', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='touches', to='candidates.Candidate')),
                ('consideration', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='candidate_touches', to='candidates.Consideration')),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='touches', to='candidates.CandidateCompoundSource')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CandidateSourceCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32)),
                ('sources', models.ManyToManyField(blank=True, through='candidates.CandidateCompoundSource', to='candidates.CandidateSource')),
            ],
        ),
        migrations.AddField(
            model_name='candidatesource',
            name='categories',
            field=models.ManyToManyField(blank=True, through='candidates.CandidateCompoundSource', to='candidates.CandidateSourceCategory'),
        ),
        migrations.AddField(
            model_name='candidatecompoundsource',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='candidates.CandidateSourceCategory'),
        ),
        migrations.AddField(
            model_name='candidatecompoundsource',
            name='source',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='candidates.CandidateSource'),
        ),
        migrations.AddConstraint(
            model_name='candidatecompoundsource',
            constraint=models.UniqueConstraint(fields=('category', 'source'), name='idxccscs'),
        ),
    ]
