import logging

from intranet.femida.src.candidates.choices import SUBMISSION_SOURCES, SUBMISSION_STATUSES
from intranet.femida.src.candidates.models import Reference, CandidateSubmission
from intranet.femida.src.startrek.utils import StartrekError
from intranet.femida.src.candidates.tasks import create_reference_issue_task
from intranet.femida.src.candidates.startrek.issues import create_reference_issue

logger = logging.getLogger(__name__)


def _create_reference(form_data, initiator):
    reference = Reference.objects.create(created_by=initiator)
    reference.vacancies.set(form_data['publications'])
    return reference


def _create_submission(form_data, reference):
    # Заполняем не-m2m поля CandidateSubmission, которые есть в ReferenceForm
    submission_model_fields = {
        'first_name',
        'last_name',
        'email',
        'phone',
        'comment',
    }
    submission_data = {
        field: value
        for field, value in form_data.items()
        if field in submission_model_fields
    }
    if form_data['attachments']:
        submission_data['attachment'] = form_data['attachments'][0]

    # Заполняем поля CandidateSubmission, которых нет в ReferenceForm
    submission_data['source'] = SUBMISSION_SOURCES.reference
    submission_data['status'] = SUBMISSION_STATUSES.draft
    submission_data['reference'] = reference
    submission = CandidateSubmission.objects.create(**submission_data)

    return submission


def create_reference(data, initiator):
    reference = _create_reference(data, initiator)
    _create_submission(data, reference)

    try:
        create_reference_issue(
            reference=reference,
        )
    except StartrekError:
        logger.exception('Failed to create REFERENCE issue. Trying to create it asynchronously.')
        create_reference_issue_task.delay(
            reference_id=reference.id,
        )
    return reference
