import sform

from intranet.femida.src.candidates.models import Candidate
from intranet.femida.src.api.core.forms import PositiveDecimalField
from intranet.femida.src.core.exceptions import SimpleValidationError


class CandidateScoringUploadForm(sform.SForm):

    candidate = sform.SuggestField(
        queryset=Candidate.unsafe.all(),
        state=sform.REQUIRED,
        label_fields=['pk'],
    )
    scoring_value = PositiveDecimalField(state=sform.REQUIRED)

    def clean_candidate(self, candidate):
        if candidate.id in self.context['candidate_ids']:
            raise SimpleValidationError('duplicate_candidate_id')
        return candidate
