from django.dispatch import Signal, receiver

from intranet.femida.src.candidates.choices import (
    CONSIDERATION_IN_PROGRESS_EXTENDED_STATUSES_WITHOUT_OFFER,
)
from intranet.femida.src.candidates.tasks import (
    send_candidate_reference_event_task,
    send_consideration_onedayoffer_event_task,
)


candidate_modified = Signal(providing_args=['candidate'])
consideration_status_changed = Signal(providing_args=['consideration'])
verification_on_check = Signal(providing_args=['verification', 'candidate'])
verification_succeeded = Signal(providing_args=['verification', 'candidate'])
verification_failed = Signal(providing_args=['verification', 'candidate'])


@receiver(consideration_status_changed)
def send_event_to_issues(sender, consideration, **kwargs):
    extended_status = consideration.extended_status
    if extended_status in CONSIDERATION_IN_PROGRESS_EXTENDED_STATUSES_WITHOUT_OFFER:
        send_candidate_reference_event_task.delay(consideration.candidate_id, extended_status)
    send_consideration_onedayoffer_event_task.delay(consideration.id, extended_status)
