from intranet.femida.src.candidates.choices import VERIFICATION_STATUSES, VERIFICATION_RESOLUTIONS
from intranet.femida.src.candidates.models import Verification
from intranet.femida.src.candidates.signals import verification_succeeded, verification_failed
from intranet.femida.src.notifications.candidates import (
    VerificationSuccessNotification,
    VerificationFailureNotification,
)
from intranet.femida.src.startrek.utils import ResolutionEnum
from intranet.femida.src.utils.datetime import shifted_now


def handle_verification_resolution(verification, resolution):
    if resolution == ResolutionEnum.fixed:
        notification = VerificationSuccessNotification
        verification.resolution = VERIFICATION_RESOLUTIONS.hire
        verification.expiration_date = shifted_now(months=3)
        signal = verification_succeeded
    elif resolution == ResolutionEnum.declined:
        notification = VerificationFailureNotification
        verification.resolution = VERIFICATION_RESOLUTIONS.nohire
        verification.expiration_date = shifted_now(months=3)
        signal = verification_failed
    elif resolution == ResolutionEnum.wont_fix:
        notification = VerificationFailureNotification
        verification.resolution = VERIFICATION_RESOLUTIONS.blacklist
        verification.expiration_date = shifted_now(years=1000)
        signal = verification_failed
    else:
        raise Exception('Unknown %s issue resolution: %s' % (
            verification.startrek_ess_key,
            resolution,
        ))

    verification.status = VERIFICATION_STATUSES.closed
    verification.save(update_fields=['resolution', 'expiration_date', 'status', 'modified'])

    notification(verification).send()

    signal.send(Verification, verification=verification, candidate=verification.candidate)

    return verification
