from constance import config

from intranet.femida.src.candidates.models import Verification
from intranet.femida.src.utils.strings import fetch_comma_separated_integers


def is_verification_required_for_department(department):
    if not department:
        return True
    skip_department_ids = fetch_comma_separated_integers(config.SKIP_VERIFICATION_DEPARTMENT_IDS)
    return not department.is_in_trees(skip_department_ids)


def is_verification_required(offer):
    return is_verification_required_for_department(offer.department)


def get_previous_ess_issues_keys(candidate_id):
    return list(
        Verification.objects
        .filter(candidate_id=candidate_id)
        .exclude(startrek_ess_key='')
        .order_by("-created")
        .values_list('startrek_ess_key', flat=True)
    )
