from django.contrib import admin

from . import models


class CertificationAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'consideration',
        'created_by',
    )
    search_fields = (
        '=id',
        '=consideration__candidate__id',
    )
    list_select_related = (
        'consideration__candidate',
        'created_by',
    )
    list_display = (
        'id',
        'candidate_full_name',
        'is_published',
        'created_by',
        'created',
    )
    list_filter = (
        'is_published',
    )

    def candidate_full_name(self, obj):
        return obj.consideration.candidate.get_full_name()


admin.site.register(models.Certification, CertificationAdmin)
