from constance import config

from intranet.femida.src.interviews.choices import INTERVIEW_STATES
from intranet.femida.src.utils.strings import fetch_comma_separated_integers


def get_considerations_for_certification(candidate):
    """
    Отдаёт рассмотрения, доступные для сертификата диагностики навыков.
    """
    vacancy_ids = fetch_comma_separated_integers(config.CERTIFICATION_VACANCY_IDS)
    return (
        candidate.considerations
        .filter(
            certification__isnull=True,
            interviews__application__vacancy__in=vacancy_ids,
            interviews__state=INTERVIEW_STATES.finished,
        )
        .distinct()
    )
