import uuid

from django.conf import settings
from django.db import models
from model_utils.models import TimeStampedModel


class Certification(TimeStampedModel):

    consideration = models.OneToOneField(
        to='candidates.Consideration',
        related_name='certification',
        on_delete=models.PROTECT,
    )
    private_uuid = models.UUIDField(default=uuid.uuid4)
    public_uuid = models.UUIDField(default=uuid.uuid4)
    is_published = models.BooleanField(default=False)
    published_at = models.DateTimeField(
        blank=True,
        null=True,
    )
    created_by = models.ForeignKey(
        to=settings.AUTH_USER_MODEL,
        related_name='+',
        on_delete=models.PROTECT,
    )

    @property
    def private_url(self):
        return f'{settings.JOBS_RU_URL}skill-diagnostic/private/{self.private_uuid}'

    def __str__(self):
        return 'ID {}, Published at: {}'.format(self.id, self.published_at)
