from django.utils import timezone

from intranet.femida.src.core.workflow import Action, Workflow


class CertificationPublishAction(Action):

    def is_status_correct(self):
        return not self.instance.is_published

    def perform(self, **params):
        self.instance.is_published = True
        self.instance.published_at = timezone.now()
        self.instance.save()
        return self.instance


class CertificationUnpublishAction(Action):

    def is_status_correct(self):
        return self.instance.is_published

    def perform(self, **params):
        self.instance.is_published = False
        self.instance.published_at = None
        self.instance.save()
        return self.instance


class CertificationWorkflow(Workflow):

    ACTION_MAP = {
        'publish': CertificationPublishAction,
        'unpublish': CertificationUnpublishAction,
    }
