from django.contrib import admin

from . import models


class CommentAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'created_by',
    )

    list_display = (
        'id',
        'content_type',
        'object_id',
        'created',
    )

    list_filter = (
        'content_type',
    )


admin.site.register(models.Comment, CommentAdmin)
