from intranet.femida.src.comments.models import Comment
from intranet.femida.src.core.controllers import update_instance
from intranet.femida.src.notifications.comments import notify_about_comment_create


def update_or_create_comment(data, initiator=None, instance=None):
    if instance:
        is_edited = instance.text != data['text']
        if is_edited:
            data['is_edited'] = True
        update_instance(instance, data)
    else:
        data['created_by'] = initiator
        instance = Comment(**data)
        instance.save(force_insert=True)
        notify_about_comment_create(instance, initiator)

    return instance
