from django.conf import settings
from django.contrib.contenttypes.fields import GenericForeignKey
from django.contrib.contenttypes.models import ContentType
from django.db import models
from model_utils.models import TimeStampedModel

from intranet.femida.src.wf.models import WFModelMixin


class Comment(WFModelMixin, TimeStampedModel):
    """
    Сквозная таблица комментариев
    """

    WIKI_FIELDS_MAP = {
        'text': 'formatted_text',
    }

    content_type = models.ForeignKey(ContentType, on_delete=models.CASCADE)
    object_id = models.PositiveIntegerField()
    related_object = GenericForeignKey()

    text = models.TextField()
    formatted_text = models.TextField()

    created_by = models.ForeignKey(
        to=settings.AUTH_USER_MODEL,
        related_name='created_comments',
        on_delete=models.PROTECT,
    )
    is_edited = models.BooleanField(default=False)

    def __str__(self):
        return 'Comment {} for {} {}'.format(self.id, self.content_type, self.object_id)

    class Meta:
        ordering = ('-created',)
