from intranet.femida.src.comments.controllers import update_or_create_comment
from intranet.femida.src.core.workflow import Workflow, Action


class UpdateAction(Action):

    def has_permission(self):
        return self.user == self.instance.created_by

    def perform(self, **params):
        return update_or_create_comment(params, self.user, self.instance)


class DeleteAction(Action):

    def has_permission(self):
        return self.user == self.instance.created_by

    def perform(self, **params):
        self.instance.delete()
        return self.instance


class CommentWorkflow(Workflow):

    ACTION_MAP = {
        'update': UpdateAction,
        'delete': DeleteAction,
    }
