from django.contrib import admin

from . import models


class MessageAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'candidate',
        'application',
        'author',
    )

    search_fields = (
        '=id',
        '=application__id',
    )

    list_display = (
        'id',
        'candidate',
        'subject',
        'type',
        'status',
        'author',
    )

    list_filter = (
        'type',
        'status',
    )

    list_select_related = (
        'candidate',
        'application',
        'author',
    )


class MessageAttachmentAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'message',
        'attachment',
    )

    search_fields = (
        'id',
        'message__id',
        'attachment__id',
    )

    list_display = (
        'id',
        'message',
        'attachment',
    )


class MessageTemplateAdmin(admin.ModelAdmin):

    list_display = (
        'id',
        'type',
        'name',
        'category_name',
        'subject',
        'is_active',
        'modified',
    )

    list_filter = (
        'type',
    )


class ReminderAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'user',
        'message',
    )

    search_fields = (
        '=id',
        '=message__id',
        'user__username',
    )

    list_display = (
        'id',
        'remind_at',
        'status',
        'user',
        'message',
    )

    list_select_related = (
        'user',
        'message',
    )


admin.site.register(models.Message, MessageAdmin)
admin.site.register(models.MessageAttachment, MessageAttachmentAdmin)
admin.site.register(models.MessageTemplate, MessageTemplateAdmin)
admin.site.register(models.Reminder, ReminderAdmin)
