from django.utils.translation import ugettext_noop as _
from model_utils.choices import Choices


EXTERNAL_MESSAGE_TYPES = Choices(
    ('incoming', _('message.type.incoming')),
    ('outcoming', _('message.type.outcoming')),
)

COMMENT_MESSAGE_TYPES = Choices(
    ('internal', _('message.type.internal')),
    ('brief', _('message.type.brief')),
)

MESSAGE_TYPES = (
    EXTERNAL_MESSAGE_TYPES
    + COMMENT_MESSAGE_TYPES
    + Choices(
        ('official', 'note', _('message.type.official')),
    )
)

MESSAGE_STATUSES = Choices(
    # Показывают статус отправки email кандидату
    ('draft', _('message.status.draft')),
    ('scheduled', _('message.status.scheduled')),
    ('sending', _('message.status.sending')),

    ('sent', _('message.status.sent')),
    ('failed', _('message.status.failed')),
    ('deleted', _('message.status.deleted')),
)

MESSAGE_TEMPLATE_TYPES = Choices(
    ('communication', _('message_template.type.communication')),
    ('interview', _('message_template.type.interview')),
    ('hr_screening', _('message_template.type.hr_screening')),
    ('reference', _('message_template.type.reference')),
    ('submission_rejection', _('message_template.type.submission_rejection')),
    ('signature', _('message_template.type.signature')),
    ('certification', _('message_template.type.certification')),
)

REMINDER_STATUSES = Choices(
    ('scheduled', _('reminder.status.scheduled')),
    ('sending', _('reminder.status.sending')),
    ('sent', _('reminder.status.sent')),
)
