from django.db.models import Prefetch

from intranet.femida.src.communications.choices import REMINDER_STATUSES
from intranet.femida.src.communications.models import Reminder


def prefetch_user_reminders(user, to_attr='user_reminders'):
    reminders_qs = (
        Reminder.objects
        .filter(
            user=user,
            status=REMINDER_STATUSES.scheduled,
        )
        .select_related('user')
    )
    return Prefetch('reminders', reminders_qs, to_attr)
