# Generated by Django 1.11.2 on 2018-08-20 19:08
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import intranet.femida.src.wf.models
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('attachments', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Message',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    )
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    )
                ),
                (
                    'type',
                    models.CharField(
                        choices=[
                            ('incoming', 'message.type.incoming'),
                            ('outcoming', 'message.type.outcoming'),
                            ('internal', 'message.type.internal'),
                            ('brief', 'message.type.brief'),
                            ('official', 'message.type.official'),
                        ],
                        db_index=True,
                        default='internal',
                        max_length=32,
                    )
                ),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('draft', 'message.status.draft'),
                            ('scheduled', 'message.status.scheduled'),
                            ('sending', 'message.status.sending'),
                            ('sent', 'message.status.sent'),
                            ('failed', 'message.status.failed'),
                            ('deleted', 'message.status.deleted'),
                        ],
                        db_index=True,
                        default='sent',
                        max_length=16,
                    ),
                ),
                ('subject', models.CharField(blank=True, max_length=255)),
                ('text', models.TextField()),
                ('html', models.TextField(blank=True)),
                ('cleaned_text', models.TextField(blank=True, null=True)),
                ('ignore_wiki_format', models.NullBooleanField()),
                ('email', models.CharField(blank=True, db_index=True, default='', max_length=255)),
                ('separator_message_id', models.CharField(blank=True, max_length=255)),
                (
                    'attachments',
                    models.ManyToManyField(
                        related_name='messages',
                        through='communications.MessageAttachment',
                        to='attachments.Attachment',
                    ),
                ),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            bases=(intranet.femida.src.wf.models.WFModelMixin, models.Model),
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='MessageAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('content_type', models.CharField(blank=True, max_length=255)),
                ('attachment', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='message_attachments', to='attachments.Attachment')),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='message_attachments', to='communications.Message')),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='MessageTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(
                    choices=[
                        ('communication', 'message_template.type.communication'),
                        ('hr_screening', 'message_template.type.hr_screening'),
                        ('reference', 'message_template.type.reference'),
                    ],
                    default='communication',
                    max_length=16,
                )),
                ('category_name', models.CharField(blank=True, max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('subject', models.CharField(blank=True, max_length=255)),
                ('text', models.TextField()),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
