# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-07-15 19:19
from logging import getLogger

from django.db import migrations
from django.db.models import Case, When, Value


logger = getLogger(__name__)


def rename_status(apps, schema_editor):
    Message = apps.get_model('communications', 'Message')
    last_message = Message.unsafe.order_by('-id').first()
    if not last_message:
        return
    
    last_id = last_message.id
    batch_size = 10000
    first = 0
    
    qs = Message.unsafe.filter(status__in=('added', 'changed'))
    is_changed_update = Case(
        When(status='changed', is_changed=Value(True)),
        default=Value(False),
    )
    
    for last in range(batch_size, last_id, batch_size):
        updated_count = (
            qs
            .filter(
                id__gt=first,
                id__lte=last,
            )
            .update(
                status='sent',
                is_changed=is_changed_update,
            )
        )
        logger.info('RENAME STATUS DONE: from %s to %s, updated %s', first, last, updated_count)
        first = last
        
    updated_count = qs.filter(id__gt=first).update(status='sent', is_changed=is_changed_update)
    logger.info('RENAME STATUS DONE: from %s, updated %s', first, updated_count)


def rollback_status(apps, schema_editor):
    Message = apps.get_model('communications', 'Message')
    Message.unsafe.filter(status='sent').update(status='added')
    Message.unsafe.filter(is_changed=True, status='sent').update(status='changed')


class Migration(migrations.Migration):
    atomic = False
    
    dependencies = [
        ('communications', '0004_scheduled_messages_scheme'),
    ]

    operations = [
        migrations.RunPython(rename_status, reverse_code=rollback_status),
    ]
