# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-08-09 11:51
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('communications', '0005_scheduled_messages_data'),
    ]

    operations = [
        migrations.CreateModel(
            name='Reminder',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'remind_at',
                    models.DateTimeField(),
                ),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('scheduled', 'reminder.status.scheduled'),
                            ('sending', 'reminder.status.sending'),
                            ('sent', 'reminder.status.sent'),
                        ],
                        default='scheduled',
                        max_length=32,
                    ),
                ),
                (
                    'message',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='reminders',
                        to='communications.Message',
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='reminders',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
