# Generated by Django 2.2.28 on 2022-07-21 19:00

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('candidates', '0048_verification_type'),
    ]

    operations = [
        migrations.CreateModel(
            name='Contest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now,
                                                                editable=False,
                                                                verbose_name='created')),
                ('modified',
                 model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now,
                                                          editable=False, verbose_name='modified')),
                ('contest_id', models.IntegerField(db_index=True)),
                ('name', models.CharField(max_length=255, null=True)),
                ('url', models.TextField(blank=True)),
                ('is_odo', models.BooleanField(default=False)),
                ('is_infinite', models.BooleanField(default=False)),
                ('started_at', models.DateTimeField(blank=True)),
                ('finishing_at', models.DateTimeField(blank=True, null=True)),
                ('pass_code', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContestParticipant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now,
                                                                editable=False,
                                                                verbose_name='created')),
                ('modified',
                 model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now,
                                                          editable=False, verbose_name='modified')),
                ('participant_id', models.IntegerField(db_index=True, null=True)),
                ('state', models.CharField(
                    choices=[('invitation_link_sent', 'invitation_link_sent'),
                             ('started_contest', 'started_contest'),
                             ('finished_contest', 'finished_contest')], max_length=32)),
                ('challenge', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT,
                                                to='candidates.Challenge')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContestProblem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now,
                                                                editable=False,
                                                                verbose_name='created')),
                ('modified',
                 model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now,
                                                          editable=False, verbose_name='modified')),
                ('problem_origin_id', models.CharField(db_index=True, max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('alias', models.CharField(max_length=255)),
                ('maxScore', models.IntegerField(null=True)),
                ('html_text', models.TextField(null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('contest', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT,
                                              related_name='problems', to='contest.Contest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContestSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                        verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now,
                                                                editable=False,
                                                                verbose_name='created')),
                ('modified',
                 model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now,
                                                          editable=False, verbose_name='modified')),
                ('status', models.CharField(
                    choices=[('not_submitted', 'not_submitted'), ('partly_solved', 'partly_solved'),
                             ('needs_review', 'needs_review'), ('solved', 'solved')],
                    max_length=32)),
                ('verdict', models.CharField(max_length=32)),
                ('score', models.CharField(max_length=32, null=True)),
                ('total_submit_count', models.CharField(max_length=32, null=True)),
                ('time_from_start', models.TimeField(null=True)),
                ('run_id', models.IntegerField(null=True)),
                ('contest', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT,
                                              to='contest.Contest')),
                ('participant', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT,
                                                  to='contest.ContestParticipant')),
                ('problem', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT,
                                              to='contest.ContestProblem')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
