from django.db import models
from model_utils.models import TimeStampedModel

from intranet.femida.src.contest.choices import (
    PARTICIPANT_STATE_TYPES,
    SUBMISSION_STATE_TYPES,
)


class Contest(TimeStampedModel):
    contest_id = models.IntegerField(db_index=True)
    name = models.CharField(max_length=255, null=True)
    url = models.TextField(blank=True)
    is_odo = models.BooleanField(default=False)
    is_infinite = models.BooleanField(default=False)
    started_at = models.DateTimeField(blank=True)
    finishing_at = models.DateTimeField(blank=True, null=True)
    pass_code = models.CharField(max_length=255, null=True)


class ContestProblem(TimeStampedModel):
    contest = models.ForeignKey(
        to=Contest,
        related_name='problems',
        on_delete=models.PROTECT,
        null=False,
        db_index=True
    )
    problem_origin_id = models.CharField(
        max_length=255,
        db_index=True
    )
    name = models.CharField(max_length=255)
    alias = models.CharField(max_length=255)
    max_score = models.IntegerField(null=True)
    html_text = models.TextField(null=True)
    type = models.CharField(max_length=255, null=True)


class ContestParticipant(TimeStampedModel):
    participant_id = models.IntegerField(
        null=True,
        db_index=True
    )
    state = models.CharField(
        choices=PARTICIPANT_STATE_TYPES,
        max_length=32
    )
    forms_answer_id = models.CharField(
        null=True,
        max_length=255,
        db_index=True
    )
    yandex_uid = models.IntegerField(
        null=True,
    )


class ContestSubmission(TimeStampedModel):
    participant = models.ForeignKey(
        to=ContestParticipant,
        on_delete=models.PROTECT
    )
    contest = models.ForeignKey(
        to=Contest,
        on_delete=models.PROTECT
    )
    problem = models.ForeignKey(
        to=ContestProblem,
        on_delete=models.PROTECT
    )
    status = models.CharField(
        choices=SUBMISSION_STATE_TYPES,
        max_length=32,
    )

    verdict = models.CharField(
        max_length=32
    )

    score = models.CharField(
        null=True,
        max_length=32
    )
    total_submit_count = models.CharField(
        null=True,
        max_length=32
    )
    time_from_start = models.TimeField(null=True)

    run_id = models.IntegerField(null=True)
