from rest_framework import serializers

from intranet.femida.src.contest.models import Contest, ContestProblem


class ProblemsSerializer(serializers.ModelSerializer):
    class Meta:
        model = ContestProblem
        fields = (
            'problem_origin_id',
            'name',
            'alias',
            'max_score',
            'html_text',
        )


class ContestSerializer(serializers.ModelSerializer):
    problems = ProblemsSerializer(many=True)

    class Meta:
        model = Contest
        fields = (
            'contest_id',
            'name',
            'url',
            'started_at',
            'finishing_at',
            'problems'
        )
