from django.utils.translation import ugettext_noop as _
from model_utils import Choices


def get_partial_choices(choices, *args):
    return Choices(*[(arg, choices._identifier_map[arg], choices[arg]) for arg in args])


GENDER_CHOICES = Choices(
    ('male', _('gender.male')),
    ('female', _('gender.female')),
)


DRF_THROTTLE_SCOPES = Choices(
    'ext_form_check_login',
    'ext_form_attachment_upload',
    'ext_form_accept',
)


LANGUAGES = Choices(
    ('ru', 'Russian'),
    ('en', 'English'),
)
