import yenv

from django.contrib.auth.models import AnonymousUser


def yenv_type(request):
    return {
        'yenv_type': yenv.type,
    }


def permissions(request):
    if isinstance(request.user, AnonymousUser):
        return {
            'is_recruiter': False,
            'is_recruiting_manager': False,
            'is_moderator': False,
            'is_interviewer': False,
        }

    return {
        'is_recruiter': request.user.is_recruiter,
        'is_recruiting_manager': request.user.is_recruiting_manager,
        'is_moderator': request.user.is_moderator,
        'is_interviewer': True,
    }


def timezone(request):
    return {
        'tz': request.user.timezone if not isinstance(request.user, AnonymousUser) else None,
    }
