from django.db.models import Field, Lookup


@Field.register_lookup
class Any(Lookup):
    """
    Аналог оператора IN, который умеет искать по массиву.
    Важно! Работает только с OuterRef.
    Для остальных случаев lookup ещё нужно дорабатывать
    """
    lookup_name = 'any'

    def as_sql(self, qn, connection):
        lhs, lhs_params = self.process_lhs(qn, connection)
        rhs, rhs_params = self.process_rhs(qn, connection)
        params = lhs_params + rhs_params
        sql = '{} = ANY {}'.format(lhs, rhs)
        return sql, params
