import logging

from django.conf import settings
from django_idm_api.hooks import AuthHooks

from intranet.femida.src.staff.tasks import give_aa_achievement, take_away_aa_achievement

logger = logging.getLogger(__name__)


class FemidaHooks(AuthHooks):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.role_to_aa_type = {f'group-{v}': k for k, v in settings.AA_TYPE_TO_GROUP_ID.items()}

    def add_role_impl(self, login, role, *args, **kwargs):
        super().add_role_impl(login, role, *args, **kwargs)
        if role['role'] in self.role_to_aa_type:
            aa_type = self.role_to_aa_type[role['role']]
            give_aa_achievement.delay(login, aa_type)

    def remove_role_impl(self, login, role, *args, **kwargs):
        super().remove_role_impl(login, role, *args, **kwargs)
        if role['role'] in self.role_to_aa_type:
            aa_type = self.role_to_aa_type[role['role']]
            take_away_aa_achievement.delay(login, aa_type)
