from django.db import connection
from django.core.management.base import BaseCommand


class Command(BaseCommand):

    help = 'Set denormalization fields in db'

    def handle(self, *args, **options):
        cursor = connection.cursor()

        sql_pattern = (
            'UPDATE {to_table} as T1 SET {field} = T2.{field} '
            'FROM {from_table} as T2 WHERE T1.{join_field} = T2.id;'
        )

        cursor.execute(sql_pattern.format(
            to_table='interviews_interview',
            from_table='interviews_application',
            field='candidate_id',
            join_field='application_id',
        ))
        cursor.execute(sql_pattern.format(
            to_table='vacancies_vacancy',
            from_table='professions_profession',
            field='professional_sphere_id',
            join_field='profession_id',
        ))
        cursor.execute(sql_pattern.format(
            to_table='candidates_candidateprofession',
            from_table='professions_profession',
            field='professional_sphere_id',
            join_field='profession_id',
        ))
        cursor.execute(sql_pattern.format(
            to_table='offers_offer',
            from_table='interviews_application',
            field='candidate_id',
            join_field='application_id',
        ))
        cursor.execute(sql_pattern.format(
            to_table='offers_offer',
            from_table='interviews_application',
            field='vacancy_id',
            join_field='application_id',
        ))
