from django.db import connection
from django.core.management.base import BaseCommand


class Command(BaseCommand):

    help = 'Migrate `datetime without time zone` to `datetime with time zone` in PostgreSQL.'

    def handle(self, *args, **options):
        c = connection.cursor()
        c.execute(
            "SELECT table_name, column_name "
            "FROM INFORMATION_SCHEMA.COLUMNS "
            "WHERE data_type LIKE '%without%';"
        )
        for line in c.fetchall():
            c.execute(
                "ALTER TABLE %(table)s ALTER %(column)s "
                "TYPE timestamptz USING %(column)s AT TIME ZONE 'UTC';" % {
                    'table': line[0],
                    'column': line[1],
                }
            )
