from django.apps import apps as django_apps
from django.contrib.auth.management import create_permissions
from django.core.management.base import BaseCommand


class Command(BaseCommand):

    help = 'Reloads permissions for specified apps, or all apps if no args are specified'

    def handle(self, *args, **options):
        if args:
            apps = {django_apps.get_app_config(arg) for arg in args}
        else:
            apps = django_apps.get_app_configs()

        for app in apps:
            create_permissions(app, int(options.get('verbosity', 3)))
