# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-07-20 10:06
from django.contrib.postgres.operations import UnaccentExtension
from django.db import migrations
from django.conf import settings


# Note: Миграция потерялась при схлопывании всех миграций.
# На давно существующих базах нужно выполнить через
# femida migrate core 0003 --fake
class Migration(migrations.Migration):

    dependencies = [
        ('core', '0002_constance_muted_tasks'),
    ]

    operations = [
        UnaccentExtension(),
        # Create russian_unaccent search config
        migrations.RunSQL(
            sql=(
                "CREATE TEXT SEARCH CONFIGURATION {search_config}( COPY = russian ); "
                "ALTER TEXT SEARCH CONFIGURATION {search_config} "
                "ALTER MAPPING FOR hword, hword_part, word "
                "WITH unaccent, russian_stem".format(
                    search_config=settings.PG_TEXT_SEARCH_CONFIG,
                )
            ),
            reverse_sql=(
                "DROP TEXT SEARCH CONFIGURATION IF EXISTS {search_config}".format(
                    search_config=settings.PG_TEXT_SEARCH_CONFIG,
                )
            ),
        ),
    ]
