import logging

from django.http import Http404

from intranet.femida.src.offers.choices import OFFER_NEWHIRE_STATUSES
from intranet.femida.src.offers.mixins import OfferByUidViewMixin, PreprofileByUidViewMixin
from intranet.femida.src.utils.authdata import AuthDataMixinBase

from .views import IndexViewBase


logger = logging.getLogger(__name__)


class ExternalIndexView(AuthDataMixinBase, IndexViewBase):

    template_name = 'external-index.html'
    bundle = 'femida-external'

    csp_report_service = 'yandex-hire'
    csp_connect_sources = [
        "'self'",
        'yandex.ru',
        'mc.yandex.ru',
        'mc.webvisor.com',
        'mc.webvisor.org',
        'api.stat.yandex-team.ru',
        'suggest-maps.yandex.ru',
    ]
    csp_font_sources = [
        'yastatic.net',
        'yastat.net',
    ]
    csp_img_sources = [
        "'self'",
        'avatars.mds.yandex.net',
        'yastatic.net',
        'yastat.net',
        'mc.yandex.ru',
        'mc.webvisor.com',
        'mc.webvisor.org',
    ]
    csp_script_sources = [
        'avatars.mds.yandex.net',
        'yastatic.net',
        'yastat.net',
        'mc.yandex.ru',
        'mc.webvisor.com',
        'mc.webvisor.org',
        'api-maps.yandex.ru',
    ]
    csp_style_sources = [
        "'unsafe-inline'",
        'yastatic.net',
        'yastat.net',
    ]
    csp_child_sources = [
        'blob:',
        'mc.yandex.ru',
    ]
    csp_frame_sources = [
        'blob:',
        'mc.yandex.ru',
    ]


class OfferAcceptIndexView(OfferByUidViewMixin, ExternalIndexView):

    bundle = 'offers-external'
    bundle_rum_code = 3578

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        context['LANGUAGE_CODE'] = self.get_language()
        return context

    def get(self, request, *args, **kwargs):
        # Выкидываем 404, если оффер не найден
        self.offer
        return super().get(request, *args, **kwargs)


class PreprofileIndexView(PreprofileByUidViewMixin, ExternalIndexView):

    bundle = 'offers-external'
    bundle_rum_code = 3578

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        context['LANGUAGE_CODE'] = self.get_language()
        return context

    def get(self, request, *args, **kwargs):
        # Выкидываем 404, если препрофайл не найден
        # или статус не позволяет заполнить анкету
        valid_statuses = (
            OFFER_NEWHIRE_STATUSES.new,
            OFFER_NEWHIRE_STATUSES.prepared,
        )
        if self.ctl.newhire_status not in valid_statuses:
            raise Http404
        return super().get(request, *args, **kwargs)
