from constance.signals import config_updated
from constance import config
from django.dispatch import receiver

from intranet.femida.src.utils.frontend import update_manifest, FrontendManifestError


@receiver(config_updated)
def constance_updated(sender, key, old_value, new_value, **kwargs):
    if key != 'FRONTEND_VERSION':
        return

    try:
        update_manifest(old_value, new_value)
    except FrontendManifestError:
        # при откате транзакции нужно ещё сбросить кэш
        if config._backend._cache:
            config._backend._cache.delete('FRONTEND_VERSION')
        raise
