Vue.use(VueResource);
Vue.use(VTooltip);


var app = new Vue({
    el: '#app',
    data: {
        selected: '',
        count: 0,
        nextPage: '',
        records: [],
        filterParams: {
            page_size: 30,
            action_name: ''
        },
        actionNames: []
    },
    methods: {
        getLog: function(isNextPage) {
            var self = this;

            if (isNextPage) {
                this.$http.get(self.nextPage).then(function(response) {
                    self.nextPage = response.data.next;
                    response.data.results.forEach(function(record) {
                        self.records.push(record);
                    });
                });
            } else {
                self.records = [];
                this.$http.get('/api/log/', {params: self.filterParams}).then(function(response) {
                    self.nextPage = response.data.next;
                    response.data.results.forEach(function(record) {
                        self.records.push(record);
                    });
                });
            }
        },
        getActionNames: function() {
            var self = this;

            this.$http.get('/api/log/_meta/').then(function(response) {
                response.data.action_names.forEach(function(item) {
                    self.actionNames.push(item.name);
                });
            });
        }
    },
    created: function() {
        this.getLog();
        this.getActionNames();
    },
    filters: {
        moment: function(date) {
            return moment(date).format('DD MMMM YYYY, HH:mm:ss');
        },
        json: function(value) {
            return JSON.stringify(value, null, 2);
        }
    }
});
