from intranet.femida.src.utils.url_shortener import get_short_femida_url

from . import exceptions
from .api import HeadhunterAPI
from .oauth import HeadhunterOAuth


class HHAuthenticateMixin:
    """
    Миксин для вьюх, с помощью которого можно определить
    авторизован пользователь в HH или нет.
    """
    @property
    def short_current_path(self):
        return get_short_femida_url(self.request.get_full_path())

    def get_hh_authentication_details(self):
        """
        Вычисляет авторизован пользователь или нет.
        Возвращает 2 параметра:
        - флаг авторизован/не авторизован
        - ссылка для авторизации
        :return: tuple (is_authenticated, authorization_url)
        """
        try:
            HeadhunterAPI(self.request.user).get_me()
        except exceptions.HeadhunterTokenExpiredError:
            return False, HeadhunterOAuth.get_token_refresh_url(self.short_current_path)
        except exceptions.HeadhunterOauthError:
            return False, HeadhunterOAuth.get_oauth_url(self.short_current_path)
        else:
            return True, None
