from django.conf import settings
from django.contrib.contenttypes.fields import GenericForeignKey
from django.contrib.contenttypes.models import ContentType
from django.db import models
from model_utils.models import TimeStampedModel

from intranet.femida.src.candidates.choices import LINKED_ENTITY_TYPES


class HHOauthToken(TimeStampedModel):
    """
    Токены для походов в HH
    """
    user = models.OneToOneField(
        to=settings.AUTH_USER_MODEL,
        related_name='+',
        on_delete=models.PROTECT,
    )
    access_token = models.CharField(max_length=255)
    refresh_token = models.CharField(max_length=255)
    expiry_date = models.DateTimeField()

    def __str__(self):
        return 'HH token {}'.format(self.access_token)


# TODO: вынести из приложения hh и переименовать
class HHEntityLink(TimeStampedModel):
    """
    Маппинг справочников внешних источников со справочниками Фемиды
    """

    # Маппинг может быть не только на id,
    # но и на строки. Например, скиллы в HH
    # - это просто строки, аналогичные нашим тегам.
    # Поэтому решили назвать поле более абстрактно - "key".
    key = models.CharField(max_length=128)
    type = models.CharField(
        max_length=16,
        choices=LINKED_ENTITY_TYPES,
        default=LINKED_ENTITY_TYPES.hh,
    )

    description = models.CharField(max_length=255, blank=True)
    content_type = models.ForeignKey(ContentType, on_delete=models.CASCADE)
    object_id = models.PositiveIntegerField()
    related_object = GenericForeignKey()

    def __str__(self):
        return 'Linked Entity Key {}, {}'.format(self.key, self.description)

    class Meta:
        unique_together = ('key', 'content_type', 'object_id')
