from django.contrib import admin

from intranet.femida.src.core.admin import format_url, pretty_json

from . import models


class HireOrderHistoryInlineAdmin(admin.TabularInline):

    model = models.HireOrderHistory
    extra = 1
    readonly_fields = (
        'changed_at',
    )


@admin.register(models.HireOrder)
class HireOrderAdmin(admin.ModelAdmin):

    list_display = (
        'uuid',
        'created_by',
        'status',
        'resolution',
        'created',
        'modified',
    )
    list_select_related = (
        'created_by',
    )
    list_filter = (
        'status',
        'resolution',
    )
    date_hierarchy = 'created'
    search_fields = (
        '=uuid',
    )

    raw_id_fields = (
        'created_by',
        'recruiter',
        'candidate',
        'vacancy',
        'application',
        'offer',
    )
    readonly_fields = (
        'created',
        'modified',
        'pretty_raw_data',
        'pretty_table_flow_data',
        'vacancy_url',
    )
    inlines = (
        HireOrderHistoryInlineAdmin,
    )

    def pretty_raw_data(self, obj):
        return pretty_json(obj.raw_data)

    def pretty_table_flow_data(self, obj):
        return pretty_json(obj.table_flow_data)

    def vacancy_url(self, obj):
        if obj.vacancy_id:
            return format_url(f'/vacancies/{obj.vacancy_id}/', f'VAC {obj.vacancy_id} (фронт)')
        return '-'
