from django.utils.translation import ugettext_noop as _
from model_utils.choices import Choices


# Note: это предварительный список статусов и резолюций,
# по ходу движения по цели может сильно поменяться
HIRE_ORDER_ACTIVE_STATUSES = Choices(
    ('new', _('hire_order.status.new')),
    ('candidate_prepared', _('hire_order.status.candidate_prepared')),
    ('vacancy_on_approval', _('hire_order.status.vacancy_on_approval')),
    ('vacancy_prepared', _('hire_order.status.vacancy_prepared')),
    ('verification_sent', _('hire_order.status.verification_sent')),
    ('verification_on_check', _('hire_order.status.verification_on_check')),
    ('offer_on_approval', _('hire_order.status.offer_on_approval')),
    ('offer_sent', _('hire_order.status.offer_sent')),
    ('offer_accepted', _('hire_order.status.offer_accepted')),
    ('preprofile_approved', _('hire_order.status.preprofile_approved')),
    ('preprofile_ready', _('hire_order.status.preprofile_ready')),
)
HIRE_ORDER_STATUSES = HIRE_ORDER_ACTIVE_STATUSES + Choices(
    ('closed', _('hire_order.status.closed')),
)
HIRE_ORDER_RESOLUTIONS = Choices(
    ('incorrect', _('hire_order.resolution.incorrect')),
    ('invalid_candidate', _('hire_order.resolution.invalid_candidate')),
    ('verification_failed', _('hire_order.resolution.verification_failed')),
    ('vacancy_unapproved', _('hire_order.resolution.vacancy_unapproved')),
    ('offer_unapproved', _('hire_order.resolution.offer_unapproved')),
    ('hired', _('hire_order.resolution.hired')),
    ('cancelled', _('hire_order.resolution.cancelled')),
)
