# Generated by Django 2.2.9 on 2020-06-03 11:44

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('candidates', '0018_candidate_submission_remove_null'),
        ('offers', '0025_add_eds_phone_fields'),
        ('interviews', '0007_add_proposal_factors'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('vacancies', '0014_publicationsubscription_hash_not_nullable'),
    ]

    operations = [
        migrations.CreateModel(
            name='HireOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False)),
                ('status', models.CharField(
                    choices=[
                        ('new', 'hire_order.status.new'),
                        ('candidate_prepared', 'hire_order.status.candidate_prepared'),
                        ('vacancy_on_approval', 'hire_order.status.vacancy_on_approval'),
                        ('vacancy_prepared', 'hire_order.status.vacancy_prepared'),
                        ('verification_sent', 'hire_order.status.verification_sent'),
                        ('verification_on_check', 'hire_order.status.verification_on_check'),
                        ('offer_on_approval', 'hire_order.status.offer_on_approval'),
                        ('offer_sent', 'hire_order.status.offer_sent'),
                        ('offer_accepted', 'hire_order.status.offer_accepted'),
                        ('preprofile_approved', 'hire_order.status.preprofile_approved'),
                        ('preprofile_ready', 'hire_order.status.preprofile_ready'),
                        ('closed', 'hire_order.status.closed'),
                    ],
                    default='new',
                    max_length=32,
                )),
                ('resolution', models.CharField(
                    blank=True,
                    choices=[
                        ('incorrect', 'hire_order.resolution.incorrect'),
                        ('invalid_candidate', 'hire_order.resolution.invalid_candidate'),
                        ('verification_failed', 'hire_order.resolution.verification_failed'),
                        ('vacancy_unapproved', 'hire_order.resolution.vacancy_unapproved'),
                        ('offer_unapproved', 'hire_order.resolution.offer_unapproved'),
                        ('hired', 'hire_order.resolution.hired'),
                        ('cancelled', 'hire_order.resolution.cancelled'),
                    ],
                    max_length=32,
                )),
                ('resolution_description', models.TextField(blank=True)),
                ('raw_data', django.contrib.postgres.fields.jsonb.JSONField()),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='interviews.Application')),
                ('candidate', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='candidates.Candidate')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('offer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='offers.Offer')),
                ('recruiter', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('vacancy', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='vacancies.Vacancy')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HireOrderHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(
                    choices=[
                        ('new', 'hire_order.status.new'),
                        ('candidate_prepared', 'hire_order.status.candidate_prepared'),
                        ('vacancy_on_approval', 'hire_order.status.vacancy_on_approval'),
                        ('vacancy_prepared', 'hire_order.status.vacancy_prepared'),
                        ('verification_sent', 'hire_order.status.verification_sent'),
                        ('verification_on_check', 'hire_order.status.verification_on_check'),
                        ('offer_on_approval', 'hire_order.status.offer_on_approval'),
                        ('offer_sent', 'hire_order.status.offer_sent'),
                        ('offer_accepted', 'hire_order.status.offer_accepted'),
                        ('preprofile_approved', 'hire_order.status.preprofile_approved'),
                        ('preprofile_ready', 'hire_order.status.preprofile_ready'),
                        ('closed', 'hire_order.status.closed'),
                    ],
                    max_length=32,
                )),
                ('resolution', models.CharField(
                    blank=True,
                    choices=[
                        ('incorrect', 'hire_order.resolution.incorrect'),
                        ('invalid_candidate', 'hire_order.resolution.invalid_candidate'),
                        ('verification_failed', 'hire_order.resolution.verification_failed'),
                        ('vacancy_unapproved', 'hire_order.resolution.vacancy_unapproved'),
                        ('offer_unapproved', 'hire_order.resolution.offer_unapproved'),
                        ('hired', 'hire_order.resolution.hired'),
                        ('cancelled', 'hire_order.resolution.cancelled'),
                    ],
                    max_length=32,
                )),
                ('changed_at', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False)),
                ('hire_order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='history', to='hire_orders.HireOrder')),
            ],
        ),
    ]
