# Generated by Django 2.2.24 on 2021-08-04 17:15
import hashlib
import json

from django.db import migrations


def fill_sha1(apps, schema_editor):
    HireOrder = apps.get_model('hire_orders', 'HireOrder')
    hire_orders_to_update = []
    for obj in HireOrder.objects.all():
        json_data = json.dumps(obj.raw_data, sort_keys=True, ensure_ascii=False)
        obj.sha1 = hashlib.sha1(json_data.encode('utf-8')).hexdigest()
        hire_orders_to_update.append(obj)
    HireOrder.objects.bulk_update(hire_orders_to_update, ['sha1'], batch_size=1000)


class Migration(migrations.Migration):

    dependencies = [
        ('hire_orders', '0003_hireorder_sha1'),
    ]

    operations = [
        migrations.RunPython(fill_sha1, reverse_code=migrations.RunPython.noop),
    ]
