from django.contrib import admin

from intranet.femida.src.notifications.tasks import remind_about_unfinished_interviews
from . import models


class AssignmentAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'problem',
        'interview',
    )

    search_fields = (
        'id',
        'problem__id',
        'problem__summary',
        'interview__id',
    )

    list_display = (
        'id',
        'problem',
        'interview',
        'grade',
    )

    list_filter = (
        'grade',
    )


def _remind_about_unfinished_interviews(modeladmin, request, queryset):
    remind_about_unfinished_interviews()


_remind_about_unfinished_interviews.short_description = (
    'Отправить уведомления о незавершенных секциях'
)


class InterviewAdmin(admin.ModelAdmin):

    actions = [_remind_about_unfinished_interviews]

    raw_id_fields = (
        'application',
        'interviewer',
        'optional_participant',
        'created_by',
        'finished_by',
        'consideration',
        'candidate',
        'round',
        'potential_interviewers',
    )

    search_fields = (
        'id',
        'application__id',
        'interviewer__username',
        'optional_participant__username',
        'application__candidate__id',
        'state',
    )

    list_display = (
        'id',
        'application',
        'interviewer',
        'finished',
        'state',
        'grade',
        'yandex_grade',
        'consideration',
    )

    list_filter = (
        'state',
        'grade',
        'yandex_grade',
    )

    list_select_related = (
        'application__candidate',
        'consideration__created_by',
        'interviewer',
        'optional_participant',
    )


class InterviewRoundTimeSlotInlineAdmin(admin.TabularInline):

    model = models.InterviewRoundTimeSlot


class InterviewRoundInterviewInlineAdmin(admin.TabularInline):

    model = models.Interview

    fields = (
        'section',
        'state',
        'type',
        'event_id',
    )


class InterviewRoundAdmin(admin.ModelAdmin):

    list_display = (
        'id',
        'type',
        'status',
        'created_by',
        'candidate_id',
        'consideration_id',
    )
    list_select_related = (
        'created_by',
    )
    list_filter = (
        'type',
        'status',
        'planner',
    )
    search_fields = (
        '=id',
        '=candidate__id',
        '=consideration__id',
    )

    raw_id_fields = (
        'candidate',
        'consideration',
        'created_by',
        'message',
    )
    inlines = (
        InterviewRoundTimeSlotInlineAdmin,
        InterviewRoundInterviewInlineAdmin,
    )


admin.site.register(models.Assignment, AssignmentAdmin)
admin.site.register(models.Interview, InterviewAdmin)
admin.site.register(models.InterviewRound, InterviewRoundAdmin)
