from django.conf import settings
from django.utils.translation import ugettext_noop as _
from model_utils import Choices

from intranet.femida.src.core.choices import get_partial_choices


INTERVIEW_GRADABLE_TYPES = Choices(
    ('screening', _('interview.type.screening')),
    ('regular', _('interview.type.regular')),
    ('aa', _('interview.type.aa')),
)

INTERVIEW_TYPES = INTERVIEW_GRADABLE_TYPES + Choices(
    ('hr_screening', _('interview.type.hr_screening')),
    ('final', _('interview.type.final')),
)


INTERVIEW_TYPES_TRANSLATIONS = {
    INTERVIEW_TYPES.screening: 'Предварительная секция',
    INTERVIEW_TYPES.regular: 'Стандартная секция',
    INTERVIEW_TYPES.aa: 'AA секция',
    INTERVIEW_TYPES.hr_screening: 'HR скрининг',
    INTERVIEW_TYPES.final: 'Финальная секция',
}

INTERVIEW_TYPES_TRANSLATIONS_EXTERNAL = {
    INTERVIEW_TYPES.screening: 'Skype-интервью',
    INTERVIEW_TYPES.regular: 'Очное интервью',
    INTERVIEW_TYPES.aa: 'Очное интервью',
    INTERVIEW_TYPES.hr_screening: 'Интервью с рекрутером',
    INTERVIEW_TYPES.final: 'Интервью-знакомство с командой',
}

INTERVIEW_STATES = Choices(
    ('draft', _('interview.status.draft')),
    ('assigned', _('interview.status.assigned')),
    ('estimated', _('interview.status.estimated')),
    ('finished', _('interview.status.finished')),
    ('cancelled', _('interview.status.cancelled')),
)

INTERVIEW_ALIVE_STATES = get_partial_choices(
    INTERVIEW_STATES,
    INTERVIEW_STATES.assigned,
    INTERVIEW_STATES.estimated,
    INTERVIEW_STATES.finished,
)

INTERVIEW_UNFINISHED_STATES = get_partial_choices(
    INTERVIEW_STATES,
    INTERVIEW_STATES.assigned,
    INTERVIEW_STATES.estimated,
)

INTERVIEW_RESOLUTIONS = Choices(
    ('hire', _('interview.resolution.hire')),
    ('nohire', _('interview.resolution.nohire')),
)


INTERVIEW_RESOLUTIONS_TRANSLATIONS = {
    INTERVIEW_RESOLUTIONS.hire: 'Рассматриваем',
    INTERVIEW_RESOLUTIONS.nohire: 'Отказываем',
}

INTERVIEW_RESOLUTIONS_TRANSLATIONS_EN = {
    INTERVIEW_RESOLUTIONS.hire: 'Hire',
    INTERVIEW_RESOLUTIONS.nohire: 'Do not hire',
}


AA_TYPES = Choices(*[
    (aa_type, _(f'interview.aa_type.{aa_type}'))
    for aa_type in settings.AA_TYPES
])


INTERVIEW_HIRE_GRADES = Choices(
    (1, _('interview.grade.hire_1')),
    (2, _('interview.grade.hire_2')),
    (3, _('interview.grade.hire_3')),
    (4, _('interview.grade.hire_4')),
    (5, _('interview.grade.hire_5')),
    (6, _('interview.grade.hire_6')),
    (7, _('interview.grade.hire_7')),
    (8, _('interview.grade.hire_8')),
)

INTERVIEW_HIRE_GRADES_TRANSLATIONS_EN = {
    0: 'Do not hire',
    1: 'Hire, I Intern',
    2: 'Hire, II Junior',
    3: 'Hire, III Specialist',
    4: 'Hire, IV Specialist',
    5: 'Hire, V Senior',
    6: 'Hire, VI Lead',
    7: 'Hire, VII Lead',
    8: 'Hire, VIII Expert',
}


INTERVIEW_GRADES = Choices(
    (0, _('interview.grade.nohire'))
) + INTERVIEW_HIRE_GRADES

INTERVIEW_YANDEX_GRADES = Choices(0) + Choices(*range(9, 20))

INTERVIEW_SCALES = Choices(
    ('old', _('interview.scale.old')),
    ('new', _('interview.scale.new')),
)

INTERVIEW_REVIEW_REASONS = Choices(
    ('newbie', _('interview.review_reason.newbie')),
    ('random', _('interview.review_reason.random')),
    ('request', _('interview.review_reason.request')),
)

INTERVIEW_ROUND_TYPES = Choices(
    ('screening', _('interview_round.type.screening')),
    ('onsite', _('interview_round.type.onsite')),
    ('final', _('interview_round.type.final')),
)

INTERVIEW_ROUND_PLANNERS = Choices(
    ('femida', _('interview_round.planner.femida')),
    ('yang', _('interview_round.planner.yang')),
)

INTERVIEW_ROUND_STATUSES = Choices(
    ('new', _('interview_round.status.new')),
    ('planning', _('interview_round.status.planning')),
    ('planned', _('interview_round.status.planned')),
    ('cancelled', _('interview_round.status.cancelled')),
)

INTERVIEW_ROUND_LUNCH_DURATIONS = Choices(
    (0, 'no_lunch', _('interview_round.lunch_duration.no_lunch')),
    (30, 'minutes_30', _('interview_round.lunch_duration.minutes_30')),
    (60, 'minutes_60', _('interview_round.lunch_duration.minutes_60')),
    (90, 'minutes_90', _('interview_round.lunch_duration.minutes_90')),
)

INTERVIEW_ROUND_ORDERINGS = Choices(
    ('any', _('interview_round.ordering.any')),
    ('strict', _('interview_round.ordering.strict')),
    ('aa_last', _('interview_round.ordering.aa_last')),
)


OPEN_APPLICATION_STATUSES = Choices(
    ('draft', _('application.status.draft')),
    ('in_progress', _('application.status.in_progress')),
)


APPLICATION_STATUSES = OPEN_APPLICATION_STATUSES + Choices(
    ('closed', _('application.status.closed')),
)


APPLICATION_FILTER_FORM_STATUSES = Choices(
    ('open', _('application.filter_form.status.open')),
) + APPLICATION_STATUSES


APPLICATION_STATUSES_TRANSLATIONS = {
    APPLICATION_STATUSES.draft: 'Черновик',
    APPLICATION_STATUSES.in_progress: 'В работе',
    APPLICATION_STATUSES.closed: 'Закрыто',
}

# Статусы из OEBS, которые считаются архивными
# 1 - Акт. назначение
# 6 - Оффер принят
# 7 - Закрыто
# 12095 - Приостановлено
OEBS_ARCHIVED_APPLICATION_STATUSES = [1, 6, 7, 12095]

IN_PROGRESS_APPLICATION_RESOLUTIONS = Choices(
    ('test_task_sent', _('application.resolution.test_task_sent')),
    ('test_task_done', _('application.resolution.test_task_done')),
    ('invited_to_preliminary_interview', _(
        'application.resolution.invited_to_preliminary_interview'
    )),
    ('invited_to_onsite_interview', _('application.resolution.invited_to_onsite_interview')),
    ('invited_to_final_interview', _('application.resolution.invited_to_final_interview')),
    ('offer_agreement', _('application.resolution.offer_agreement')),
)

# Не создаются после FEMIDA-3920
CLOSED_APPLICATION_RESOLUTIONS_DEPRECATED = Choices(
    ('rejected_by_resume', _('application.resolution.rejected_by_resume')),
    ('rejected_after_test_task', _('application.resolution.rejected_after_test_task')),
    ('rejected_after_screening', _('application.resolution.rejected_after_screening')),
    ('rejected_after_preliminary_interview', _(
        'application.resolution.rejected_after_preliminary_interview'
    )),
    ('rejected_after_onsite_interview', _(
        'application.resolution.rejected_after_onsite_interview'
    )),
    ('rejected_after_final_interview', _('application.resolution.rejected_after_final_interview')),
    ('refused_did_not_respond', _('application.resolution.refused_did_not_respond')),
    ('refused_after_vacancy_proposal', _('application.resolution.refused_after_vacancy_proposal')),
    ('refused_after_test_task', _('application.resolution.refused_after_test_task')),
    ('refused_after_screening', _('application.resolution.refused_after_screening')),
    ('refused_after_preliminary_interview', _(
        'application.resolution.refused_after_preliminary_interview'
    )),
    ('refused_after_onsite_interview', _('application.resolution.refused_after_onsite_interview')),
    ('refused_after_final_interview', _('application.resolution.refused_after_final_interview')),
    ('duplicate', _('application.resolution.duplicate')),
    ('no_offer', _('application.resolution.no_offer')),
)

CLOSED_APPLICATION_RESOLUTIONS_MANAGEABLE = Choices(
    ('did_not_pass_assessments', _('application.resolution.did_not_pass_assessments')),
    ('team_was_not_interested', _('application.resolution.team_was_not_interested')),
    ('team_was_not_selected', _('application.resolution.team_was_not_selected')),
    ('refused_us', _('application.resolution.refused_us')),
    ('offer_rejected', _('application.resolution.offer_rejected')),
    ('offer_accepted', _('application.resolution.offer_accepted')),
    ('rotated', _('application.resolution.rotated')),
    ('vacancy_closed', _('application.resolution.vacancy_closed')),
    ('incorrect', _('application.resolution.incorrect')),
    ('on_hold', _('application.resolution.on_hold')),
)

CLOSED_APPLICATION_RESOLUTIONS = (
    CLOSED_APPLICATION_RESOLUTIONS_MANAGEABLE
    + Choices(
        ('consideration_archived', _('application.resolution.consideration_archived')),
    )
)

CLOSED_APPLICATION_RESOLUTIONS_WITH_DEPRECATED = (
    CLOSED_APPLICATION_RESOLUTIONS
    + CLOSED_APPLICATION_RESOLUTIONS_DEPRECATED
)

APPLICATION_RESOLUTIONS = (
    IN_PROGRESS_APPLICATION_RESOLUTIONS
    + CLOSED_APPLICATION_RESOLUTIONS_WITH_DEPRECATED
)

APPLICATION_RESOLUTIONS_TRANSLATIONS = {
    APPLICATION_RESOLUTIONS.test_task_sent: 'Отправлено тестовое задание',
    APPLICATION_RESOLUTIONS.test_task_done: 'Выполнено тестовое задание',
    APPLICATION_RESOLUTIONS.invited_to_preliminary_interview: (
        'Приглашен на предварительное интервью'
    ),
    APPLICATION_RESOLUTIONS.invited_to_onsite_interview: 'Приглашен на очное собеседование',
    APPLICATION_RESOLUTIONS.invited_to_final_interview: 'Приглашен на финальное собеседование',
    APPLICATION_RESOLUTIONS.offer_agreement: 'Согласование оффера',
    APPLICATION_RESOLUTIONS.on_hold: 'Отложен',
    APPLICATION_RESOLUTIONS.rejected_by_resume: 'Отказали мы по резюме или отклику',
    APPLICATION_RESOLUTIONS.rejected_after_test_task: 'Отказали мы после тестового задания',
    APPLICATION_RESOLUTIONS.rejected_after_screening: 'Отказали мы после скрининга рекрутера',
    APPLICATION_RESOLUTIONS.rejected_after_preliminary_interview: (
        'Отказали мы после предварительного интервью'
    ),
    APPLICATION_RESOLUTIONS.rejected_after_onsite_interview: (
        'Отказали мы после очного собеседования'
    ),
    APPLICATION_RESOLUTIONS.rejected_after_final_interview: (
        'Отказали мы после финального собеседования'
    ),
    APPLICATION_RESOLUTIONS.refused_did_not_respond: 'Отказался сам не ответил',
    APPLICATION_RESOLUTIONS.refused_after_vacancy_proposal: (
        'Отказался сам после предложения вакансии'
    ),
    APPLICATION_RESOLUTIONS.refused_after_test_task: 'Отказался сам после тестового задания',
    APPLICATION_RESOLUTIONS.refused_after_screening: 'Отказался сам после скрининга с рекрутером',
    APPLICATION_RESOLUTIONS.refused_after_preliminary_interview: (
        'Отказался сам после предварительного интервью'
    ),
    APPLICATION_RESOLUTIONS.refused_after_onsite_interview: (
        'Отказался сам после очного собеседования'
    ),
    APPLICATION_RESOLUTIONS.refused_after_final_interview: (
        'Отказался сам после финального собеседования'
    ),
    APPLICATION_RESOLUTIONS.offer_rejected: 'Отказался от оффера',
    APPLICATION_RESOLUTIONS.offer_accepted: 'Оффер принят/Нанят',
    APPLICATION_RESOLUTIONS.vacancy_closed: 'Вакансия закрыта, не успели рассмотреть',
    APPLICATION_RESOLUTIONS.duplicate: 'Дубликат',
    APPLICATION_RESOLUTIONS.no_offer: 'Решили не делать оффер',
    APPLICATION_RESOLUTIONS.rotated: 'Ротирован',
    APPLICATION_RESOLUTIONS.team_was_not_selected: 'Команда не попала на очное',
    APPLICATION_RESOLUTIONS.team_was_not_interested: 'Не заинтересованы в очном',
    APPLICATION_RESOLUTIONS.incorrect: 'Некорректный',
    APPLICATION_RESOLUTIONS.refused_us: 'Отказался от вакансии',
    APPLICATION_RESOLUTIONS.did_not_pass_assessments: 'Не прошел испытания',
    APPLICATION_RESOLUTIONS.consideration_archived: 'Рассмотрение завершено',
}

APPLICATION_CLOSE_REASONS = Choices(
    ('vacancy_closed', _('application.close_reason.vacancy_closed')),
    ('forgotten', _('application.close_reason.forgotten')),
    ('offer_rejected', _('application.close_reason.offer_rejected')),
)


APPLICATION_SOURCES = Choices(
    ('recruiter', _('application.source.recruiter')),
    ('submission', _('application.source.submission')),
    ('proposal', _('application.source.proposal')),
    ('request', _('application.source.request')),
)


APPLICATION_PROPOSAL_STATUSES = Choices(
    ('undefined', _('application.proposal_status.undefined')),
    ('accepted', _('application.proposal_status.accepted')),
    ('rejected', _('application.proposal_status.rejected')),
)


APPLICATION_SORTING_TYPES = Choices(
    ('created', _('application.sorting.created')),
    ('modified', _('application.sorting.modified')),
)


APPLICATION_HIRING_STAGES = Choices(
    # Кандидат предложен = входной поток.
    # Кандидат предложен команде, команда еще не реагировала
    ('proposed', _('application.hiring_stage.proposed')),

    # Команда заинтересована в кандидате = команда ждёт секции
    ('team_is_interested', _('application.hiring_stage.team_is_interested')),

    # Назначена очка, секции кандидата ещё идут = что-то запланировано
    ('interview_assigned', _('application.hiring_stage.interview_assigned')),

    # Секции завершены
    ('interview_finished', _('application.hiring_stage.interview_finished')),
)


APPLICATION_DASHBOARD_STAGES = Choices(
    'draft',
    'new',
    'team_is_interested',
    'invited_to_preliminary_interview',
    'invited_to_onsite_interview',
    'invited_to_final_interview',
    'offer_agreement',
    'closed',
) + CLOSED_APPLICATION_RESOLUTIONS
